var aFile = File.openDialog ( 'Select text file with timings:', '*.txt', false ) ;
var timings = loadTimings(aFile);

//list of compositions
var compList = app.project.items;

if(compList.length > 0) {

	//1. take the first composition OR
	//var currentComposition = compList[1];
	
	//2. take currently active composition
	var currentComp = app.project.activeItem;

	if(currentComp.layers.length > 0) {

		//take the first layer of the active composition
		var markerLayer = currentComp.layer(1)

		for (var i = 0; i < timings.length; i++) {
			marker = timings[i].split('\t');
			var marker_label = "";
			var l = marker.length
			if(l > 2) {
				marker_label = marker[2];
			}
			markerLayer.property("Marker").setValueAtTime(marker[0], new MarkerValue(marker_label))
		}	
	}
	else {
		alert("No layer in this composition. Create a layer first. It can be a Null Object layer.");
	}
}
else {
		alert("No composition in the project. Create a composition first. Its duration should be equal or longer than the end timestamp of the last marker.");
	}



//loads markers from Audacity text files with labels
function loadTimings(filePath) {

var timings = new Array ( ) ;

var fileObj = File(filePath);
if ( ! fileObj.exists ) {
return timings ;
}

try {
fileObj.open('r');

while(! fileObj.eof) {
var currentLine = fileObj.readln();
timings.push(currentLine);
}
fileObj.close();
}
catch (errMain) {
}
return timings;
}